package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.block.TileEntityDNASequencer;

import java.util.Iterator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ResourceLocation;

public class ContainerDNASequencer extends Container{

	TileEntityDNASequencer te;

	ResourceLocation needleDna = new ResourceLocation("CloneCraft:textures/items/needleDnaUnderlay.png");
	ResourceLocation paper = new ResourceLocation("CloneCraft:textures/items/paperUnderlay.png");
	ResourceLocation fuel = new ResourceLocation("CloneCraft:textures/items/fuelUnderlay.png");
	
	public ContainerDNASequencer(InventoryPlayer playerInven, TileEntityDNASequencer te) {
		this.te = te;
		this.addSlotToContainer(new SlotFuel(te, 0, 8, 95));
		this.getSlot(0).setBackgroundIconTexture(fuel);
		this.addSlotToContainer(new SlotType(te, 1, 8, 7, Item.paper.itemID, -1, 1));
		this.getSlot(1).setBackgroundIconTexture(paper);
		this.addSlotToContainer(new SlotType(te, 2, 6, 51, CloneCraft.needle.itemID, 2, 1));
		this.getSlot(2).setBackgroundIconTexture(needleDna);


		for (int i = 0; i < 3; i++)
		{
			for (int k = 0; k < 9; k++)
			{
				addSlotToContainer(new Slot(playerInven, k + i * 9 + 9, 8 + k * 18, 128 + i * 18));
			}
		}
		for (int j = 0; j < 9; j++)
		{
			addSlotToContainer(new Slot(playerInven, j, 8 + j * 18, 186));
		}
	}



	@Override
	public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
		Slot slotClicked = getSlot(slotClickedIndex);
		if(slotClicked != null && slotClicked.getHasStack()){
			ItemStack clickedOn = slotClicked.getStack();
			if(slotClickedIndex > 2){
				//user inven
				if(clickedOn.itemID == Item.paper.itemID && !getSlot(1).getHasStack()){
					clickedOn.stackSize--;
					ItemStack copy = clickedOn.copy();
					copy.stackSize = 1;
					getSlot(1).putStack(copy);
				}else if(TileEntityFurnace.isItemFuel(clickedOn) && (!getSlot(0).getHasStack() || getSlot(0).getStack().stackSize < 64)){
					if (!this.mergeItemStack(clickedOn, 0, 1, false)){
						return null;
					}
				}else if(clickedOn.itemID == CloneCraft.needle.itemID && clickedOn.getItemDamage() == 2 && !getSlot(2).getHasStack()){
					clickedOn.stackSize--;
					ItemStack copy = clickedOn.copy();
					copy.stackSize = 1;
					getSlot(2).putStack(copy);
				}else if(slotClickedIndex >= 3 && slotClickedIndex < 30){
					if (!this.mergeItemStack(clickedOn, 30, 39, false)){
						return null;
					}
				}else if(slotClickedIndex >= 30 && slotClickedIndex < 39){
					if (!this.mergeItemStack(clickedOn, 3, 30, false)){
						return null;
					}
				}else{
					return null;
				}
			}else{
				//te inven
				if (!this.mergeItemStack(clickedOn, 3, 39, false)){
					return null;
				}
			}
			if (clickedOn.stackSize == 0)
            {
				slotClicked.putStack((ItemStack)null);
            }
            else
            {
            	slotClicked.onSlotChanged();
            }
			return clickedOn;
		}
		return null;
	}



	@Override
	protected void retrySlotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
       
	}



	@Override
	public boolean canInteractWith(EntityPlayer entityplayer) {
		return true;
	}



	@Override
	public void addCraftingToCrafters(ICrafting par1iCrafting) {
		super.addCraftingToCrafters(par1iCrafting);
		par1iCrafting.sendProgressBarUpdate(this, 0, te.currentItemBurnTime);
		par1iCrafting.sendProgressBarUpdate(this, 1, te.burnTime);
		par1iCrafting.sendProgressBarUpdate(this, 2, te.sequenceTime);
	}

	private int lastCurrentItemBurnTime;
	private int lastBurnTime;
	private int lastSequenceTime;

	@Override
	public void detectAndSendChanges() {
		super.detectAndSendChanges();
		Iterator var1 = crafters.iterator();
		while(var1.hasNext()){
			ICrafting crafting = (ICrafting)var1.next();
			if(te.currentItemBurnTime != lastCurrentItemBurnTime){
				crafting.sendProgressBarUpdate(this, 0, te.currentItemBurnTime);
			}
			if(te.burnTime != lastBurnTime){
				crafting.sendProgressBarUpdate(this, 1, te.burnTime);
			}
			if(te.sequenceTime != lastSequenceTime){
				crafting.sendProgressBarUpdate(this, 2, te.sequenceTime);
			}
		}

		lastCurrentItemBurnTime = te.currentItemBurnTime;
		lastBurnTime = te.burnTime;
		lastSequenceTime = te.sequenceTime;
	}

	@Override
	public void updateProgressBar(int par1, int par2) {
		if(par1 == 0){
			te.currentItemBurnTime = par2;
		}
		if(par1 == 1){
			te.burnTime = par2;
		}
		if(par1 == 2){
			te.sequenceTime = par2;
		}
	}

}
